@echo off
setlocal enabledelayedexpansion

:: ==============================================
:: UpSeller Domain Network Connectivity Tester
:: (Enhanced: Ping + HTTP/HTTPS Check)
:: ==============================================

echo.
echo reload DNS cache
echo Refreshing DNS cache...
ipconfig /flushdns
echo DNScache reloaded
echo DNS cache has been refreshed.

:: Set console title
title UpSeller Network Connectivity Check

:: Set output file path
for /f "tokens=2 delims==" %%a in ('wmic os get LocalDateTime /value') do set "datetime=%%a"
set "log_file=%userprofile%\Desktop\UpSeller_Network_Check_%datetime:~0,14%.log"
set "log_file=%log_file: =%"

:: Domain list to check
set domains=www.upseller.com www.upseller.cn app.upseller.com app.upseller.cn

:: Initialize counters
set /a total_domains=0
set /a success_count=0
set /a fail_count=0

:: >>> 额外统计 HTTP 成功/失败
set /a http_success_count=0
set /a http_fail_count=0

:: Create log file
echo UpSeller Domain Network Check Report > "%log_file%"
echo ==================================================== >> "%log_file%"
echo Check Time: %date% %time% >> "%log_file%"
echo Operating System: %OS% >> "%log_file%"
echo Computer Name: %COMPUTERNAME% >> "%log_file%"
echo User Name: %USERNAME% >> "%log_file%"
echo ==================================================== >> "%log_file%"
echo. >> "%log_file%"

:: Display start information
echo.
echo ====================================================
echo  UpSeller Domain Network Connectivity Check
echo ====================================================
echo Checking domain connectivity...
echo Results will be saved to: %log_file%
echo.

:: Step 1: Flush DNS cache
echo [1/4] Flushing DNS cache...
ipconfig /flushdns >nul
echo DNS cache has been flushed.
echo. >> "%log_file%"
echo DNS Flush Completed >> "%log_file%"

:: Step 2: Check domain connectivity
echo [2/4] Checking domain connectivity...
echo. >> "%log_file%"
echo Domain Connectivity Results: >> "%log_file%"
echo ==================================================== >> "%log_file%"

for %%d in (%domains%) do (
    set /a total_domains+=1
    echo Checking: %%d
    echo. >> "%log_file%"
    
    :: Resolve IP address
    set "domain_ip="
    for /f "tokens=2 delims=[]" %%i in ('ping -n 1 %%d ^| findstr "["') do (
        set "domain_ip=%%i"
    )
    
    :: If IP found
    if defined domain_ip (
        echo  Resolved IP: !domain_ip!
        echo Domain: %%d >> "%log_file%"
        echo Resolved IP: !domain_ip! >> "%log_file%"
        
        :: Ping test
        echo  Running ping test...
        ping -n 4 %%d >nul 2>&1
        if !errorlevel! equ 0 (
            echo  Ping Result: SUCCESS
            echo  Ping Status: Success >> "%log_file%"
            set /a success_count+=1

            :: >>> 新增：HTTP/HTTPS 检测
            echo  Running HTTP/HTTPS check...
            echo  HTTP/HTTPS Check... >> "%log_file%"

            :: 先尝试 HTTPS，再回退到 HTTP
            set "http_ok="
            :: 尝试 HTTPS
            powershell -Command ^
              "try { $r = Invoke-WebRequest -Uri 'https://%%d' -UseBasicParsing -TimeoutSec 5; if ($r.StatusCode -ge 200 -and $r.StatusCode -lt 600) { exit 0 } else { exit 1 } } catch { exit 1 }"
            if !errorlevel! equ 0 (
                set "http_ok=1"
                echo  HTTPS Result: SUCCESS
                echo  HTTPS Status: Success >> "%log_file%"
            ) else (
                echo  HTTPS Result: FAILED, trying HTTP...
                echo  HTTPS Status: Failed, will try HTTP >> "%log_file%"

                :: 尝试 HTTP
                powershell -Command ^
                  "try { $r = Invoke-WebRequest -Uri 'http://%%d' -UseBasicParsing -TimeoutSec 5; if ($r.StatusCode -ge 200 -and $r.StatusCode -lt 600) { exit 0 } else { exit 1 } } catch { exit 1 }"
                if !errorlevel! equ 0 (
                    set "http_ok=1"
                    echo  HTTP Result: SUCCESS
                    echo  HTTP Status: Success >> "%log_file%"
                ) else (
                    echo  HTTP Result: FAILED
                    echo  HTTP Status: Failed >> "%log_file%"
                )
            )

            if defined http_ok (
                set /a http_success_count+=1
            ) else (
                set /a http_fail_count+=1
            )

        ) else (
            echo  Ping Result: FAILED
            echo  Ping Status: Failed >> "%log_file%"
            set /a fail_count+=1
        )
    ) else (
        echo  DNS Lookup FAILED
        echo Domain: %%d >> "%log_file%"
        echo Status: DNS Lookup Failed >> "%log_file%"
        set /a fail_count+=1
    )
    echo. >> "%log_file%"
)

:: Step 3: Check internet connectivity
echo [3/4] Verifying internet connectivity...
echo. >> "%log_file%"
echo Internet Connectivity Check: >> "%log_file%"
echo ==================================================== >> "%log_file%"

ping -n 4 8.8.8.8 >nul
if !errorlevel! equ 0 (
    echo  Internet Access: Available
    echo Internet Connection Status: Available >> "%log_file%"
) else (
    echo  Internet Access: Unavailable
    echo Internet Connection Status: Unavailable >> "%log_file%"
)

:: Step 4: Traceroute for failed domains (ping failed)
echo [4/4] Running traceroute for failed domains...
echo. >> "%log_file%"
echo Traceroute Results for Failed Domains: >> "%log_file%"
echo ==================================================== >> "%log_file%"

for %%d in (%domains%) do (
    ping -n 1 %%d >nul 2>&1
    if not !errorlevel! equ 0 (
        echo Running traceroute for %%d
        echo Traceroute for %%d >> "%log_file%"
        tracert -d -h 8 %%d >> "%log_file%" 2>&1
        echo. >> "%log_file%"
    )
)

:: Generate summary report
echo. >> "%log_file%"
echo ==================================================== >> "%log_file%"
echo Summary Report: >> "%log_file%"
echo Checked Domains: %total_domains% >> "%log_file%"
echo Successful Pings: %success_count% >> "%log_file%"
echo Failed Pings: %fail_count% >> "%log_file%"
echo Successful HTTP/HTTPS: %http_success_count% >> "%log_file%"
echo Failed HTTP/HTTPS: %http_fail_count% >> "%log_file%"

:: Calculate percentage
set /a percentage=(success_count * 100) / total_domains
echo Ping Success Rate: %percentage%%% >> "%log_file%"

if %total_domains% gtr 0 (
    set /a http_percentage=(http_success_count * 100) / total_domains
) else (
    set http_percentage=0
)
echo HTTP/HTTPS Success Rate: %http_percentage%%% >> "%log_file%"
echo ==================================================== >> "%log_file%"

:: Add completion time
echo. >> "%log_file%"
echo Check Completed at: %date% %time% >> "%log_file%"

:: Display summary
echo.
echo ====================================================
echo  Summary Report
echo ====================================================
echo  Checked Domains: %total_domains%
echo  Successful Pings: %success_count%
echo  Failed Pings: %fail_count%
echo  Successful HTTP/HTTPS: %http_success_count%
echo  Failed HTTP/HTTPS: %http_fail_count%
echo  Ping Success Rate: %percentage%%%
echo  HTTP/HTTPS Success Rate: %http_percentage%%%
echo ====================================================

:: Final status messages
echo.
if %fail_count% gtr 0 (
    if %success_count% equ 0 (
        echo ✗ CRITICAL ISSUE: All domains failed to ping!
        echo   1. Check your internet connection
        echo   2. Verify DNS settings
        echo   3. Review firewall configuration
    ) else (
        echo ⚠️ WARNING: Some domains failed to ping.
        echo   Detailed traceroute results in log file.
    )
) else (
    if %http_fail_count% gtr 0 (
        echo ⚠️ WARNING: Ping OK but some HTTP/HTTPS checks FAILED.
        echo   This usually means server ports or applications may be down,
        echo   or blocked by firewall / security policies.
    ) else (
        echo ✓ SUCCESS: All domains are reachable via ping and HTTP/HTTPS!
    )
)

echo.
echo Check completed! Results saved to:
echo %log_file%
echo.
pause